
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */

/**
 * Representa a nave do heri
 */
public class Ship extends GameObject {

    /** Indica se est explodindo */
    private boolean isBlown = false;

    /** Array de balas */
    private Fire[] fires;

    /** Contador de balas */
    private short fireCounter;

    /** Nmero de vidas */
    private short life = Constants.LIVES;

    /** Usado para animao */
    private int tick;

    /** Indica se a nave est indo pra esquerda */
    public boolean left;

    /** Indica se a nave est indo pra direita s*/
    public boolean right;

    /**
     * Construtor
     * @param x, Posio x inicial
     * @param y, Posio y inicial
     * @param initialSequence Sequencia inicial que representam o inimigo
     * @param fires Array com as balas
     */
    public Ship(int x, int y, int[] initialSequence, Fire[] fires) {
        super(x, y, Constants.shipImage, 
        		Constants.SHIP_FRAME_WIDTH, Constants.SHIP_FRAME_HEIGHT, initialSequence);
        this.setXspeed(Constants.MY_SHIP_HORIZONTAL_SPEED);
        this.setYspeed(Constants.MY_SHIP_VERTICAL_SPEED);
        this.setVisible(true);
        this.fires = fires;
    }

    /* ************************************************************
     * O frame a ser rederizado  controlado pelo frame sequence.
     * Assim, no  necessrio redefinir o a lgica de pintura, 
     * isto , o mtodo paint(Graphics).
     * ************************************************************/

    /**
     * Atualiza a posio da nave
     */
    public void update() {
        //atualiza o tick
        tick = tick < 10 ? tick + 1 : 0;

        // Deve mover pra esquerda
        if(left)
           this.moveLeft();

        // Deve mover pra direita
        if(right)
           this.moveRight();

        // Renderiza a nave na tela
        // Se est explodindo seta a imagem da exploso
        if(isBlown) {
            this.setFrameSequence(Constants.blowShipSequence);
            if(tick == 9){
               isBlown = false;
               this.setFrameSequence(Constants.flyEnemySequence);
            }
        }

        //Desenha as imagens de acordo com o tick da animao
        if(tick < 5){
        	this.setFrame(0);
        }else{
			this.setFrame(1);
        }
    }

    /**
     * Move a nave pra esquerda
     */
    public void moveLeft(){
    	int newX = getX()-getXspeed();
    	
        // checa as bordas pra no deixar a nave sair da tela
        if(newX < 0) {
            newX = 1;
        }
    	this.setPosition(newX, getY());
    }

    /**
     * Move a nave pra direita
     */
    public void moveRight(){
    	int newX = getX()+getXspeed();
    	
        // checa as bordas pra no deixar a nave sair da tela
        if(newX + getWidth() > Constants.WIDTH) {
            newX = Constants.WIDTH - getWidth() - 1;
        }
    	this.setPosition(newX, getY());
    }

    /**
     * Atira
     */
    public void fire(){
        //seta a posio x  da bala no "meio da nave"
        //seta a posio y da bala alguns pixels "dentro da nave"
        this.fires [fireCounter].setPosition(
        		(getX() - 1 + getWidth() / 2),	// x
        		(getY() - 3)					// y
        	);

        //faz a bala aparecer
        this.fires [fireCounter].setVisible(true);

        //atualiza o contador de balas
        fireCounter++;
        fireCounter %= Constants.NUM_BULLETS;
    }

    /* *********************************************/
    /* Mtodos get() e set()
    /* *********************************************/

    public void setLife(short life) {
        this.life = life;
    }

    public short getLife() {
        return this.life;
    }

    public void setBlown(boolean isBlown) {
        this.isBlown = isBlown;
    }

    public boolean isBlown() {
        return isBlown;
    }

}
